
//~~~~~~~~~~~~~~~~~~~~~~~~~~~
#include <gc.h>
//~~~~~~~~~~~~~~~~~~~~~



//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
const unsigned char diamLevels[8] = {
                                        255, /* 1 */
                                        235, /* 2 */
                                        215, /* 3 */
                                        195, /* 4 */
                                        175, /* 5 */
                                        155, /* 6 */
                                        135, /* 7 */
                                        115, /* 8 */
                                    };
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#define DIAM_W     15
#define DIAM_H     16
#define DIAM_P     2      // UINT32 Pitch
#define DIAM_PSIZE 4

//*** The diamond bitmap or "icon".
const UINT32 diamondicon1[ DIAM_H * DIAM_P ] =
{
  0x00000008, 0x00000000,
  0x00000087, 0x80000000,
  0x00000876, 0x78000000,
  0x00008765, 0x67800000,
  0x00087654, 0x56780000,
  0x00876543, 0x45678000,
  0x08765432, 0x34567800,
  0x87654321, 0x23456780,
  0x08765432, 0x34567800,
  0x00876543, 0x45678000,
  0x00087654, 0x56780000,
  0x00008765, 0x67800000,
  0x00000876, 0x78000000,
  0x00000087, 0x80000000,
  0x00000008, 0x00000000
};


/******************************************************************************
*
*  Render_diamond  
*
*******************************************************************************
*  Fills display area with 13 by 9 set of diamond character.
*
*******************************************************************************
*  Usage:
*     Render_diamond( TGC* gc );
*
*  Arguments:
*     gc - the graphics context being drawn on.
*
*  Returns:
*     bool completed - true if the image could be drawn.
*                    - false if it can't be drawn.
*
*******************************************************************************
*/
bool Render_diamond( TGC* gc )
{
  INT16 i;
  INT32 x, y, zoom, dia_x, dia_y, div_x;

  if( !gc->Proceed() ) return true;

  gc->Versions( 1 );

  gc->SetLut( BW );

  for( i = 0; i < 8; i++ )
  {
    gc->SelectColor( i + 1 );
    gc->SetLevelGray( diamLevels[i] );
  }

  gc->ZeroActive();

  gc->Transparent( TStdColor::white );

       if( gc->height > 1440 ) zoom = 6;
  else if( gc->height > 1200 ) zoom = 5;
  else if( gc->height > 960  ) zoom = 4;
  else if( gc->height > 720  ) zoom = 3;
  else if( gc->height > 480  ) zoom = 2;
  else                         zoom = 1;

  dia_y= 9;
  if( gc->aspect > 1.33 )
  {
  	dia_x = 15;
	  div_x = 14;
  }
  else if( gc->aspect > 1.0 )
  {
	  dia_x = 13;
	  div_x = 12;
  }
  else 
  {
	  dia_x = 9;
	  div_x = 8;
  }

	switch( zoom )
	{
		case 2:
	    gc->PixelExpand ( (UINT32*)diamondicon1, DIAM_P, DIAM_PSIZE, DIAM_W, DIAM_H, 200, 200 );
	    gc->ZoomRect  ( 15, 15, 200, 200, 30, 30, 0, 0, 0L );
      gc->Opaque  ( TStdColor::black, TStdColor::black );
	    gc->FillRect( 15, 15, 200, 200 );
	    if( gc->Proceed() == false ) return true;
	    for( y = 0; y < dia_y; y += 1 )
	    {
		    for( x = 0; x < dia_x; x += 1 )
		    {
				  if( (x == 0) && (y == 0) ) continue;
		      gc->MoveRect( 30, 30, 0, 0,
			                  x * ((gc->right  - 30) / div_x ), 
                        y * ((gc->bottom - 30) / 8     ) );
		      if( gc->Proceed() == false ) return true;
		    }

		    if( gc->Proceed() == false ) return true;
	    }
	    break;

		case 3:
	    gc->PixelExpand ( (UINT32*)diamondicon1, DIAM_P, DIAM_PSIZE, DIAM_W, DIAM_H, 200, 200 );
	    gc->ZoomRect  ( 15, 15, 200, 200, 45, 45, 0, 0, 0  );
      gc->Opaque  ( TStdColor::black, TStdColor::black );
	    gc->FillRect( 15, 15, 200, 200 );
	    for( y = 0; y < dia_y; y += 1 )
	    {
		    for( x = 0; x < dia_x; x += 1 )
		    {
				  if( (x == 0) && (y == 0) ) continue;
		      gc->MoveRect( 45, 45, 0, 0,
			                  x * ((gc->right  - 45) / div_x ), 
                        y * ((gc->bottom - 45) / 8     ) );
		      if( gc->Proceed() == false ) return true;
		    }

		    if( gc->Proceed() == false ) return true;
	    }
	    break;

		case 4:
	    gc->PixelExpand ( (UINT32*)diamondicon1, DIAM_P, DIAM_PSIZE, DIAM_W, DIAM_H, 200, 200 );
	    gc->ZoomRect  ( 15, 15, 200, 200, 60, 60, 0, 0, 0  );
      gc->Opaque  ( TStdColor::black, TStdColor::black );
	    gc->FillRect( 15, 15, 200, 200 );
	    for( y = 0; y < dia_y; y += 1 )
	    {
		    for( x = 0; x < dia_x; x += 1 )
		    {
				  if( (x == 0) && (y == 0) ) continue;
		      gc->MoveRect( 60, 60, 0, 0,
			                 x * ((gc->right  - 60) / div_x ), 
                       y * ((gc->bottom - 60) / 8     ) );
		      if( gc->Proceed() == false ) return true;
		    }
		    if( gc->Proceed() == false ) return true;
	    }
	    break;

		case 5:
	    gc->PixelExpand ( (UINT32*)diamondicon1, DIAM_P, DIAM_PSIZE, DIAM_W, DIAM_H, 200, 200 );
	    gc->ZoomRect  ( 15, 15, 200, 200, 75, 75, 0, 0, 0  );
      gc->Opaque  ( TStdColor::black, TStdColor::black );
	    gc->FillRect( 15, 15, 200, 200 );
	    for( y = 0; y < dia_y; y += 1 )
	    {
		    for( x = 0; x < dia_x; x += 1 )
		    {
				  if( (x == 0) && (y == 0) ) continue;
		      gc->MoveRect( 75, 75, 0, 0,
			                  x * ((gc->right  - 75) / div_x ), 
                        y * ((gc->bottom - 75) / 8     ) );
		      if( gc->Proceed() == false ) return true;
		    }
		    if( gc->Proceed() == false ) return true;
	    }
	    break;

		case 6:
	    gc->PixelExpand ( (UINT32*)diamondicon1, DIAM_P, DIAM_PSIZE, DIAM_W, DIAM_H, 200, 200 );
	    gc->ZoomRect  ( 15, 15, 200, 200, 90, 90, 0, 0, 0  );
      gc->Opaque  ( TStdColor::black, TStdColor::black );
	    gc->FillRect( 15, 15, 200, 200 );
	    for( y = 0; y < dia_y; y += 1 )
	    {
		    for( x = 0; x < dia_x; x += 1 )
		    {
				  if( (x == 0) && (y == 0) ) continue;
		      gc->MoveRect( 90, 90, 0, 0,
			                  x * ((gc->right  - 90) / div_x ), 
                        y * ((gc->bottom - 90) / 8     ) );
		      if( gc->Proceed() == false ) return true;
		    }
		    if( gc->Proceed() == false ) return true;
	    }
	    break;

		default:
	    for( y = 0; y < dia_y; y += 1 )
	    {
		    for( x = 0; x < dia_x; x += 1 )
		    {
		      gc->PixelExpand( (UINT32*)diamondicon1, DIAM_P, DIAM_PSIZE, DIAM_W, DIAM_H,
			                   x * ((gc->right  - 15) / div_x ),
                         y * ((gc->bottom - 15) / 8     ) );
		      if( gc->Proceed() == false ) return true;
		    }
		    if( gc->Proceed() == false ) return true;
	    }
	    break;
  }
  return true;
}
